#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll key;
    ll *vals;
    int size;
    int cap;
} Group;

Group* find_group(Group *groups, int gsize, ll key) {
    for(int i = 0; i < gsize; i++) {
        if(groups[i].key == key) return &groups[i];
    }
    return NULL;
}

void add_val(Group *g, ll val) {
    if(g->size == g->cap) {
        g->cap *= 2;
        g->vals = realloc(g->vals, g->cap * sizeof(ll));
    }
    g->vals[g->size++] = val;
}

int main() {
    int N;
    scanf("%d", &N);

    ll *X = malloc(N * sizeof(ll));
    ll *Y = malloc(N * sizeof(ll));
    
    Group *byY = malloc(N * sizeof(Group));
    int byY_size = 0;
    Group *byX = malloc(N * sizeof(Group));
    int byX_size = 0;

    Group *diag1 = malloc(N * sizeof(Group));
    int diag1_size = 0;
    Group *diag2 = malloc(N * sizeof(Group));
    int diag2_size = 0;

    for(int i = 0; i < N; i++) {
        ll x, y;
        scanf("%lld %lld", &x, &y);
        X[i] = x;
        Y[i] = y;

        Group *g = find_group(byY, byY_size, y);
        if(!g) {
            g = &byY[byY_size++];
            g->key = y;
            g->cap = 2;
            g->size = 0;
            g->vals = malloc(g->cap * sizeof(ll));
        }
        add_val(g, x);

        g = find_group(byX, byX_size, x);
        if(!g) {
            g = &byX[byX_size++];
            g->key = x;
            g->cap = 2;
            g->size = 0;
            g->vals = malloc(g->cap * sizeof(ll));
        }
        add_val(g, y);

        ll d1 = x - y;
        g = find_group(diag1, diag1_size, d1);
        if(!g) {
            g = &diag1[diag1_size++];
            g->key = d1;
            g->cap = 2;
            g->size = 0;
            g->vals = malloc(g->cap * sizeof(ll));
        }
        add_val(g, 0); 
        ll d2 = x + y;
        g = find_group(diag2, diag2_size, d2);
        if(!g) {
            g = &diag2[diag2_size++];
            g->key = d2;
            g->cap = 2;
            g->size = 0;
            g->vals = malloc(g->cap * sizeof(ll));
        }
        add_val(g, 0);
    }

    ll ans = 0;

    for(int i = 0; i < byY_size; i++) {
        ll even = 0, odd = 0;
        for(int j = 0; j < byY[i].size; j++) {
            if(byY[i].vals[j] & 1) odd++;
            else even++;
        }
        ans += even * (even - 1) / 2 + odd * (odd - 1) / 2;
    }

    for(int i = 0; i < byX_size; i++) {
        ll even = 0, odd = 0;
        for(int j = 0; j < byX[i].size; j++) {
            if(byX[i].vals[j] & 1) odd++;
            else even++;
        }
        ans += even * (even - 1) / 2 + odd * (odd - 1) / 2;
    }

    for(int i = 0; i < diag1_size; i++) {
        ll c = diag1[i].size;
        ans += 2 * (c * (c - 1) / 2);
    }
    for(int i = 0; i < diag2_size; i++) {
        ll c = diag2[i].size;
        ans += 2 * (c * (c - 1) / 2);
    }

    printf("%lld\n", ans);

    for(int i = 0; i < byY_size; i++) free(byY[i].vals);
    for(int i = 0; i < byX_size; i++) free(byX[i].vals);
    for(int i = 0; i < diag1_size; i++) free(diag1[i].vals);
    for(int i = 0; i < diag2_size; i++) free(diag2[i].vals);
    free(X); free(Y);
    free(byY); free(byX); free(diag1); free(diag2);

    return 0;
}